﻿var surveyMenu = {
    context: $("#main-header"),
    getSurveyId: function () {
        return $("#survey-block", surveyMenu.context).attr("data-surveyId");
    },       
    surveys: [],
    bindEvents: function () {
        var surveyId = surveyMenu.getSurveyId();

        surveyMenu.context.on("open.dropdown", ".mega-menu-toggle", function () {
            $(".survey-name", surveyMenu.context).tooltip("close");
            $(".survey-name", surveyMenu.context).tooltip("disable");
        });

        surveyMenu.context.on("close.dropdown", ".mega-menu-toggle", function () {
            $(".survey-name", surveyMenu.context).tooltip("enable");
        });

        surveyMenu.context.on("click", "#h-print-survey", function () {
            modalDialog.showWindow(a4.getSurveyAction("Print", "Questionnaire", { surveyId: surveyId }), 750, 1000);
        });

        surveyMenu.context.on("click", ".h-stopSurvey", function () {
            a4.callServerMethod(a4.getAction("StopSurvey", "Home", "Survey"), { surveyId: surveyId }, function (result) {
                surveyMenu.refresh();
            });
        });

        surveyMenu.context.on("click", ".h-startSurvey", function () {
            a4.callServerMethod(a4.getAction("StartSurvey", "Home", "Survey"), { surveyId: surveyId }, function (result) {
                var useS2 = surveyMenu.survey.UseS2 ? "S2" : "S1";
                _paq.push(['trackEvent', 'Survey-Action-ActivateSurvey', useS2]);
                surveyMenu.refresh();
            });
        });

        surveyMenu.context.on("click", ".h-deployAction", function () {
            a4.showBusyBox();

            a4.callServerMethod(a4.getSurveyAction($(this).attr("data-action"), "Shared", { surveyId: surveyId }), null, function (result) {
                a4.hideBusyBox();
                surveyMenu.refresh();
            }, null, { type: "GET"});
        });

        surveyMenu.context.on("click", ".h-marketSightSync", function () {
            if ($(this).hasClass('disabled'))
                return;

            modalDialog.showWindow(a4.getAction("PublishInMarketSight", "Analytics", "Home", {
                itemId: surveyId,
                itemStatus: surveyMenu.survey.Status,
                isProject: false
            }), 330, 625, { afterClose: function () { surveyMenu.refresh(); } });
        });

        surveyMenu.context.on("click", ".h-surveyProperties", function () {
            modalDialog.showWindow(a4.getSurveyAction("SurveyProperties", "Home", { surveyId: surveyId }), 550, 800, { afterClose: function () { surveyMenu.refresh(); } });
        });

        surveyMenu.context.on("click", ".v-previewSurvey", function () {
            a4.previewSurvey(surveyMenu.survey.UseS2, $("#HiddenSurveyToken").val());
            mode = (surveyMenu.survey.UseS2) ? 1 : 0;
            _paq.push(['trackEvent', 'Survey-Action-PreviewSurvey', (row.UseS2 ? "S2" : "S1"), 'Editor']);
        });

        surveyMenu.context.on("click", "#h-preview-survey", function () {
            a4.previewSurvey(surveyMenu.survey.UseS2, $("#HiddenSurveyToken").val());
            mode = (surveyMenu.survey.UseS2) ? 1 : 0;
            _paq.push(['trackEvent', 'Survey-Action-PreviewSurvey', (row.UseS2 ? "S2" : "S1"), 'Survey Menu']);
        });


        surveyMenu.context.on("click", "#h-test-survey", function () {
            a4.testSurvey(surveyMenu.survey.UseS2, $("#HiddenSurveyToken").val());
        });

        surveyMenu.context.on("click", "#h-take-survey", function () {
            a4.takeSurvey(surveyMenu.survey.UseS2, $("#HiddenSurveyToken").val());
        });

        surveyMenu.context.on("click", ".h-surveyVersionHistory", function () {
            modalDialog.showWindow(a4.getSurveyAction("History", "Questionnaire", { surveyId: surveyId }), 620, 900);
            return false;
        });

        surveyMenu.context.on("click", ".h-surveySelector", function () {
            if (surveyMenu.surveys.length == 0) {
                a4.callServerMethod(a4.getSurveyAction("GetSurveysForAutoComplete", "Home"), {}, function (result) {
                    surveyMenu.surveys = result;
                    surveyMenu.renderSurveySelector(surveyMenu.surveys);
                });
            }
            else {
                surveyMenu.renderSurveySelector(surveyMenu.surveys);
            }
        });

        surveyMenu.context.on("keyup", ".h-surveySelector .h-search", function (e) {
            surveyMenu.searchSurveys($(this).val());
            return e.keyCode != 13;
        });
    },
    onBeforeRefresh: undefined,
    onAfterRefresh: undefined,
    refresh: function () {
        if (typeof surveyMenu.onBeforeRefresh === "function")
            surveyMenu.onBeforeRefresh();

        var controller = $("#survey-block", surveyMenu.context).attr("data-controller");
        var action = $("#survey-block", surveyMenu.context).attr("data-action");
        var surveyId = surveyMenu.getSurveyId();
        var previousUseS2 = surveyMenu.survey.UseS2;

        a4.callServerMethod(a4.getSurveyAction("GetMainHeader", "Shared"), { currentController: controller, currentAction: action, surveyId: surveyId },
            function (result) {
                if (result) {
                    $("#survey-block", surveyMenu.context).replaceWith(result);

                    $(".survey-name", surveyMenu.context).tooltip({
                        position: { my: "center top", at: "center bottom" }
                    });

                    if (previousUseS2 != surveyMenu.survey.UseS2)
                        window.location = window.location;
                }

                if (typeof surveyMenu.onAfterRefresh === "function")
                    surveyMenu.onAfterRefresh();
            },
            function (error) { }
        );
    },
    searchSurveys: function (value) {
        var matcher = new RegExp($.ui.autocomplete.escapeRegex(value), "i");

        var filteredSurveys = _.filter(surveyMenu.surveys, function (p) { return matcher.test(p.Label) });

        surveyMenu.renderSurveySelector(filteredSurveys);
    },
    renderSurveySelector: function (surveys) {
        var dropDown = $(".h-surveySelector .h-searchResults ul", surveyMenu.context);
        var controller = $("#survey-block", surveyMenu.context).attr("data-controller");
        var action = $("#survey-block", surveyMenu.context).attr("data-action");
        
        if (action === "NpsAnalyticsResults" && controller === "AdvancedAnalytics") {
            controller = "NpsAnalytics"
        }

        $("li", dropDown).remove();

        _.each(surveys, function (s) {
            var surveyName = s.Label.length > 43 ? s.Label.substring(0, 40) + "..." : s.Label;

            dropDown.append($("<li />").append($("<a />", { "href": a4.getSurveyAction(action, controller, { surveyId: s.Value }), "title": s.Label.length > 43 ? s.Label : null }).append(surveyName)));
        });

        dropDown.mCustomScrollbar("destroy");
        dropDown.mCustomScrollbar({ theme: "light-2", scrollInertia: 0 });
    }
};

Object.defineProperty(surveyMenu, "survey", {
    get: function () {
        return JSON.parse($("#survey-data", surveyMenu.context).val());
    }
});

$(document).ready(function () {
    surveyMenu.bindEvents();
    $(".survey-name", surveyMenu.context).tooltip({
        position: { my: "center top", at: "center bottom" }
    });
});